----------------
title : C++ 레퍼런스 - string 의 find_first_of 함수
cat_title :  find_first_of
ref_title : find_first_of, basic_string::find_first_of
path : /C++ Reference/string
publish_date : 2020-07-17
----------------

##@ cpp-ref-start

#@ find_first_of

```cpp-formatted
size_type find_first_of(const basic_string& str, size_type pos = 0) const
  noexcept;  // (1)
size_type find_first_of(const CharT* s, size_type pos,
                        size_type count) const;                       // (2)
size_type find_first_of(const CharT* s, size_type pos = 0) const;     // (3)
size_type find_first_of(CharT ch, size_type pos = 0) const noexcept;  // (4)
template <class T>
size_type find_first_of(const T& t, size_type pos = 0) const noexcept  // (5)
```

주어진 문자열에서 함수의 인자로 전달된 문자열의 문자들 중 첫 번째로 나타나는 문자의 위치를 찾는다.

예를 들어서 주어진 문자열이 *"chewing c"* 이고 *"def"* 를 인자로 전달한다면, *d, e, f* 중에 *e* 가 가장 처음에 나타나므로 (3 번째), *e* 의 위치인 2 가 리턴됩니다 (맨 첫번째가 0 이니까요).

이 함수는 `[pos, size())` 까지의 문자열 만을 찾습니다. 만일 나타나는 문자가 없을 경우 `npos` 가 리턴됩니다.

1. `str` 의 문자들 중 첫번째로 나타나는 문자를 찾는다.
2. `[s, s + count)` 의 문자들 중 첫 번째로 나타나는 문자를 찾는다. 참고로 `[s, s + count)` 범위 안에 널 문자가 포함되어 있어도 무방합니다.
3. s 가 가리키는 문자열의 문자들 중 첫 번째로 나타나는 문자를 찾는다. 이 때 s 는 널 종료 문자열이어야 한다.
4. `ch` 와 나타나는 문자열의 위치를 찾는다.
5. `t` 를 `string_view` 객체 `sv` 로 변환한다(`std::basic_string_view<CharT, Traits> sv = t;`). 그 후 `sv` 의 문자들 중 가장 먼저 나타나는 문자를 찾습니다. 참고로 T 는 `std::is_convertible_v<const T&, std::basic_string_view<CharT, Traits>>` 를 만족하고, `std::is_convertible_v<const T&, const CharT*>` 는 만족하면 안됩니다.

### 인자들

* `str`	-	찾을 문자들을 보관하는 문자열
* `pos`	-	어느 위치에서 부터 찾을 것인지
* `count`	-	찾을 문자들을 보관하는 문자열의 길이
* s	- 찾을 문자들을 가리키는 포인터
* `ch-`	찾을 문자
* `t`	-	`string_view` 로 변환 가능한 객체

### 리턴값

만일 문자가 존재할 경우 그 위치를 리턴하고, 없다면 `npos` 를 리턴합니다.

### 예시

```cpp-formatted
#include <iostream>
#include <string>

int main() {
  // 검색 대상 문자열
  std::string str = std::string("Hello World!");

  // 어떤 문자들을 찾아볼 것인가?
  std::string search_str = std::string("o");
  const char* search_cstr = "Good Bye!";

  std::cout << str.find_first_of(search_str) << '\n';
  std::cout << str.find_first_of(search_str, 5) << '\n';
  std::cout << str.find_first_of(search_cstr) << '\n';
  std::cout << str.find_first_of(search_cstr, 0, 4) << '\n';
  // 'x' 는 Hello World 에 없으므로 npos 가 리턴된다
  std::cout << str.find_first_of('x') << '\n';
}
```

실행 결과

```exec
4
7
1
4
18446744073709551615
```

### 참고 자료

* `find` : 문자열에서 문자열을 검색한다.
* `rfind` : 문자열에서 문자열을 뒤에서 부터 검색한다.
* `find_first_not_of` : 전달된 문자들 중 첫 번째로 일치하지 않는 것의 위치를 찾는다.
* `find_last_of` : 전달된 문자들 중 가장 마지막에 나타나는 문자의 위치를 찾는다.
* `find_last_not_of` : 전달된 문자들 중 마지막으로 일치하지 않는 것의 위치를 찾는다.
* `strspn` : 일치하지 않는 문자의 첫번째 위치를 찾는다.